
#include "platform.h"
#include "PinNames.h"
#include "DigitalOut.h"

using namespace mbed;

DigitalOut::DigitalOut()
	: _pin(-1)
	, _gpio(0)
	, _mask(0)
{
}

DigitalOut::DigitalOut(PinName pin, const char* name)
	: _pin(-1)
	, _gpio(0)
	, _mask(0)
{
	setup(pin, name);
}

void DigitalOut::setup(PinName pin, const char* name)
{
	_pin = pin;
	_gpio = 0;
	_mask = 0;
	if (_pin >= P0_0 && _pin <= P0_31) {
		_gpio = LPC_GPIO0;
		_mask = 1 << (_pin - P0_0);
	} else if (_pin >= P1_0 && _pin <= P1_31) {
		_gpio = LPC_GPIO1;
		_mask = 1 << (_pin - P1_0);
	} else if (_pin >= P2_0 && _pin <= P2_31) {
		_gpio = LPC_GPIO2;
		_mask = 1 << (_pin - P2_0);
	} else if (_pin >= P3_0 && _pin <= P3_31) {
		_gpio = LPC_GPIO3;
		_mask = 1 << (_pin - P3_0);
	} else if (_pin >= P4_0 && _pin <= P4_31) {
		_gpio = LPC_GPIO4;
		_mask = 1 << (_pin - P4_0);
	}
	if (_gpio) {
		_gpio->FIODIR |= _mask;
	}
}

